--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNpSystemParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj, LOCopDisplay, LOCopRender, LOCopFacing, LOCopInstance, LOCopBirth, LOCtargetEvent

  local LOCgeomArray = #(DYNuiResourcesPsystemClasses[1],  DYNuiResourcesPsystemClasses[2],  DYNuiResourcesPsystemClasses[3], DYNuiResourcesPsystemClasses[4])
  local LOCtypeArray = #(DYNuiResourcesPsystemClasses[1],  DYNuiResourcesPsystemClasses[5],  DYNuiResourcesPsystemClasses[6], DYNuiResourcesPsystemClasses[7], \
                         DYNuiResourcesPsystemClasses[8],  DYNuiResourcesPsystemClasses[2],  DYNuiResourcesPsystemClasses[3], DYNuiResourcesPsystemClasses[9], \
                         DYNuiResourcesPsystemClasses[10], DYNuiResourcesPsystemClasses[11], DYNuiResourcesPsystemClasses[12])

  local LOCmasterObject
  local LOCiniTreeKeyItem
  local LOCresourceKitMode = 1
  local LOCobjectSwitch    = 2

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsetResourceKit FUNmode =
  (
    DYNpSystemParams.LOCresourceKitMode =  FUNmode

    DYNpSystemParams.CBDYNresKt1.checked = FUNmode == 1
    DYNpSystemParams.CBDYNresKt2.checked = FUNmode == 2
    DYNpSystemParams.CBDYNresKt3.checked = FUNmode == 3

    DYNpSystemParams.CBDYNresKt1.enabled = not DYNpSystemParams.CBDYNresKt1.checked
    DYNpSystemParams.CBDYNresKt2.enabled = (DYNINIprojectKit != "0" and (DYNFUNdoesFolderExist rootNode.DYNrootNodeStore.string02)) and not DYNpSystemParams.CBDYNresKt2.checked
    DYNpSystemParams.CBDYNresKt3.enabled = (DYNINIprivateKit == "1" and (DYNFUNdoesFolderExist DYNINIprivateKitPath)) and not DYNpSystemParams.CBDYNresKt3.checked
  )

  fn DYNFUNchangePStab FUNtab =
  (
    local LOCoffset1, LOCoffset2, LOCoffset3
    LOCoffset1 = LOCoffset2 = LOCoffset3 = 0
    if FUNtab == 1 then (LOCoffset1 = 0; LOCoffset2 = LOCoffset3 = -2000; DYNpSystemParams.LBtabDescription.text = DYNuiResourcesLabels[123])
    if FUNtab == 2 then (LOCoffset2 = 0; LOCoffset1 = LOCoffset3 = -2000; DYNpSystemParams.LBtabDescription.text = DYNuiResourcesLabels[124])
    if FUNtab == 3 then (LOCoffset3 = 0; LOCoffset1 = LOCoffset2 = -2000; DYNpSystemParams.LBtabDescription.text = DYNuiResourcesLabels[125])

    if FUNtab == 3 then
    (
      DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
      DYNFUNdisplayINIobjFileArrays DYNpSystemParams.LOCobjectSwitch DYNpSystemParams DYNpSystemParams.LOCresourceKitMode
    )

    -- Tab 1
    DYNpSystemParams.GBDYN03.pos.x          = LOCoffset1 + 13
    DYNpSystemParams.LBDYNmodel01.pos.x     = LOCoffset1 + 22
    DYNpSystemParams.LBDYNmodel02.pos.x     = LOCoffset1 + 27
    DYNpSystemParams.LBDYNstring01.pos.x    = LOCoffset1 + 22
    DYNpSystemParams.LBDYNstring02.pos.x    = LOCoffset1 + 27
    DYNpSystemParams.GBDYN04.pos.x          = LOCoffset1 + 13
    DYNpSystemParams.LBDYNimported.pos.x    = LOCoffset1 + 27
    DYNpSystemParams.GBDYN05.pos.x          = LOCoffset1 + 13
    DYNpSystemParams.LBDYNsource.pos.x      = LOCoffset1 + 22
    DYNpSystemParams.LBDYNmodify01.pos.x    = LOCoffset1 + 22
    DYNpSystemParams.LBDYNmodify02.pos.x    = LOCoffset1 + 27
    DYNpSystemParams.BUDYNupdate.pos.x      = LOCoffset1 + 13

    -- Tab 2
    DYNpSystemParams.GBDYN01.pos.x          = LOCoffset2 + 13
    DYNpSystemParams.LBDYNpoints01.pos.x    = LOCoffset2 + 22
    DYNpSystemParams.CKDYNenable.pos.x      = LOCoffset2 + 22

    DYNpSystemParams.GBDYN02.pos.x          = LOCoffset2 + 13
    DYNpSystemParams.LBDYNvp01.pos.x        = LOCoffset2 + 22
    DYNpSystemParams.LBDYNre01.pos.x        = LOCoffset2 + 22
    DYNpSystemParams.DDDYNtype.pos.x        = LOCoffset2 + 22
    DYNpSystemParams.DDDYNgeom.pos.x        = LOCoffset2 + 22
    DYNpSystemParams.CKDYNnumbers.pos.x     = LOCoffset2 + 22
    DYNpSystemParams.CPDYNcolor.pos.x       = LOCoffset2 + DYNiniExplorerWidth - 60
    DYNpSystemParams.CKDYNuseNode.pos.x     = LOCoffset2 + 22

    -- Tab 3
    DYNpSystemParams.CBDYNresKt1.pos.x      = LOCoffset3 + 13
    DYNpSystemParams.CBDYNresKt2.pos.x      = LOCoffset3 + 14 + ((DYNiniExplorerWidth - 40) / 3)
    DYNpSystemParams.CBDYNresKt3.pos.x      = LOCoffset3 + 15 + ((DYNiniExplorerWidth - 40) / 3) + ((DYNiniExplorerWidth - 40) / 3)
    DYNpSystemParams.dntabCtrl.pos.x        = LOCoffset3 + 8
    DYNpSystemParams.DNDYNiniFileTree.pos.x = LOCoffset3 + 14
    DYNpSystemParams.BUDYNuseNode.pos.x     = LOCoffset3 + 13
    DYNpSystemParams.GBDYN06.pos.x          = LOCoffset3 + 13
    DYNpSystemParams.LBDYNcurObj.pos.x      = LOCoffset3 + 22
  )

  fn DYNFUNpSystemParams FUNobj =
  (
    DYNpSystemParams.LOCobj              = FUNobj
    DYNpSystemParams.CKDYNenable.checked = FUNobj.Enable_Particles

    --- Display SOurce Information
    DYNpSystemParams.LBDYNpoints01.text  = DYNuiResourcesLabels[122] + "  " + (FUNobj.numParticles() as string)

    --- Display Source Information
    DYNpSystemParams.dnTabCtrl.selectedIndex = DYNpSystemParams.LOCobjectSwitch - 1

    if (getAppData FUNobj 422) == "14" then
    (
      local LOCappData424                  = (getAppData FUNobj 424) as string
      DYNpSystemParams.LBDYNmodel02.text   = DYNFUNdisplayAppDataInUI ((getAppData FUNobj 428) as string)
      DYNpSystemParams.LBDYNstring02.text  = DYNFUNdisplayAppDataInUI ((getAppData FUNobj 427) as string)
      DYNpSystemParams.LBDYNimported.text  = DYNFUNconvertGUPdate     ((getAppData FUNobj 425) as string)
      DYNpSystemParams.LBDYNsource.text    = DYNFUNtrimPathName LOCappData424 141

      if doesFileExist LOCappData424 then
      (
        if (stricmp (getFilenameType LOCappData424) ".fil") == 0 then
        (
          --- For Model Files
          local LOCmodelName      = (getAppData FUNobj 428) as string; while LOCmodelName.count < 28 do LOCmodelName += " "
          local LOCmxModelmodDate = DYNFUNgetMxModelFileModelModifyTime LOCappData424 LOCmodelName
          DYNpSystemParams.LBDYNmodify02.text  = if classOf LOCmxModelmodDate == string then DYNFUNconvertGUPdate LOCmxModelmodDate
        )
        else
        (
          --- For other file types
          DYNpSystemParams.LBDYNmodify02.text  = DYNFUNconvertGUPdate (DYNFUNgetFileModifyTime LOCappData424 true)
        )
        if (findString DYNpSystemParams.LBDYNmodify02.text DYNuiResourcesLabels[120]) != undefined then DYNpSystemParams.LBDYNmodify02.text = "-" -- if created date is invalid
      )
      else
      (
        DYNpSystemParams.LBDYNmodify02.text  = ""
      )

      DYNpSystemParams.BUDYNupdate.enabled = if DYNpSystemParams.LBDYNmodel02.text != "" and DYNpSystemParams.LBDYNstring02.text != "" then true else false

      --- Allow objects with no model name to be updated, if object derived from LandXML
      if (stricmp (getFilenameType LOCappData424) ".xml")   == 0 and DYNpSystemParams.LBDYNstring02.text != "" then DYNpSystemParams.BUDYNupdate.enabled = true
    )
    else
    (
      DYNpSystemParams.LBDYNmodel02.text   = DYNuiResourcesLabels[121]
      DYNpSystemParams.LBDYNstring02.text  = DYNuiResourcesLabels[121]
      DYNpSystemParams.LBDYNimported.text  = DYNuiResourcesLabels[121]
      DYNpSystemParams.LBDYNsource.text    = DYNuiResourcesLabels[121]
      DYNpSystemParams.LBDYNmodify02.text  = DYNuiResourcesLabels[121]
      DYNpSystemParams.BUDYNupdate.enabled = false
    )


    --- Get Render Action
    for i = 1 to (FUNobj.numActions()) do
    (
      local LOCaction = FUNobj.getAction i

      if DYNpSystemParams.LOCopRender == undefined and classOf LOCaction == RenderParticles then DYNpSystemParams.LOCopRender = LOCaction
    )

    ---- Get Other Events
    for i = 1 to (FUNobj.getNumInitialActionLists()) do
    (
      local LOCevent = FUNobj.getInitialActionList i

      for ii = 1 to (LOCevent.numActions()) do
      (
        local LOCaction = LOCevent.getAction ii

        if DYNpSystemParams.LOCopBirth    == undefined and classof LOCaction == Birth_Script     then DYNpSystemParams.LOCopBirth    = LOCaction; DYNpSystemParams.LOCtargetEvent = LOCevent
        if DYNpSystemParams.LOCopFacing   == undefined and classof LOCaction == Shape_Facing     then DYNpSystemParams.LOCopFacing   = LOCaction
        if DYNpSystemParams.LOCopInstance == undefined and classof LOCaction == Shape_Instance   then DYNpSystemParams.LOCopInstance = LOCaction
        if DYNpSystemParams.LOCopDisplay  == undefined and classof LOCaction == DisplayParticles then DYNpSystemParams.LOCopDisplay  = LOCaction
      )
    )

    --- Update User Interface
    if DYNpSystemParams.LOCopRender != undefined then
    (
      /*
        .Type               : integer
        .Visible            : percent
        .Split_Type         : integer
        .Mesh_Count         : integer
        .Particles_Per_Mesh : integer
      */
      DYNpSystemParams.DDDYNgeom.selection = DYNpSystemParams.LOCopRender.type + 1
    )

    if DYNpSystemParams.LOCopDisplay != undefined then
    (
      /*
        .Type           : integer
        .Visible        : percent
        .Color          : RGB color
        .Show_Numbering : boolean
        .Selected_Type  : integer
      */
      DYNpSystemParams.CKDYNnumbers.checked = DYNpSystemParams.LOCopDisplay.Show_Numbering
      DYNpSystemParams.CPDYNcolor.color     = DYNpSystemParams.LOCopDisplay.Color
      DYNpSystemParams.DDDYNtype.selection  = DYNpSystemParams.LOCopDisplay.type + 1
    )

    if DYNpSystemParams.LOCopInstance != undefined then
    (
      /*
        .Shape_Object                : node
        .Group_Members               : boolean
        .Object_And_Children         : boolean
        .Object_Elements             : boolean
        .Scale_Value (Scale)         : percent
        .Variation                   : percent
        .Acquire_Mapping (Mapping)   : boolean
        .Acquire_Material (Material) : boolean
        .Random_Shape                : boolean
        .Animated_Shape              : boolean
        .Acquire_Shape               : boolean
        .Sync_Type                   : integer
        .Add_Random_Offset           : boolean
        .Random_Offset               : integer
        .Random_Seed                 : integer
        .Set_Scale                   : boolean
      */

      DYNpSystemParams.LOCmasterObject      = DYNpSystemParams.LOCopInstance.Shape_Object
      DYNpSystemParams.LBDYNcurObj.text     = if isValidNode DYNpSystemParams.LOCopInstance.Shape_Object then DYNpSystemParams.LOCopInstance.Shape_Object.name else ("<" + DYNuiResourcesLabels[120] + ">")

      local LOCindex = 0
      if (LOCtargetEvent.hasAction LOCopInstance &LOCindex) then
      (
        DYNpSystemParams.CKDYNuseNode.checked = (LOCtargetEvent.isActionActive LOCindex) == 1
      )
      else
      (
        DYNpSystemParams.CKDYNuseNode.checked = false
      )
    )
    else DYNpSystemParams.CKDYNuseNode.checked = false

    if DYNpSystemParams.LOCopFacing != undefined then
    (
      /*
        .Look_At_Object  : node
        .Parallel        : boolean
        .Size_Space      : integer
        .Units           : worldUnits
        .Inherited_Scale : percent
        .Proportion      : percent
        .Variation       : percent
        .Pivot_At        : integer
        .WH_Ratio        : float
        .Random_Seed     : integer
        .Orientation     : integer
      */
    )

    --- Enable/Disable Controls
    DYNpSystemParams.DDDYNgeom.enabled       = DYNpSystemParams.LOCopRender   != undefined


    DYNpSystemParams.CKDYNnumbers.enabled    = DYNpSystemParams.LOCopDisplay  != undefined
    DYNpSystemParams.DDDYNtype.enabled       = DYNpSystemParams.LOCopDisplay  != undefined

    DYNpSystemParams.BUDYNuseNode.enabled    = DYNpSystemParams.LOCopInstance != undefined

    DYNpSystemParams.CKDYNuseNode.enabled    = DYNpSystemParams.LOCopBirth    != undefined and DYNpSystemParams.LOCtargetEvent != undefined
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNtab pos:[4,28] width:(DYNiniExplorerWidth - 21) height:320
  dotNetControl dnRolloutTabCtrl "System.Windows.Forms.TabControl" height:23  width:(DYNiniExplorerWidth - 23) pos:[5,12]
  label LBDYNspacer pos:[10,20]
  label LBtabDescription align:#center

  --- 1st Tab
  groupbox GBDYN03 width:(DYNiniExplorerWidth - 39) height:132 pos:[2013,57]
  label LBDYNmodel01  align:#left pos:[2022,76]
  label LBDYNmodel02  align:#left pos:[2027,94] width:(DYNiniExplorerWidth - 58) height:38
  label LBDYNstring01 align:#left pos:[2022,130]
  label LBDYNstring02 align:#left pos:[2027,148] width:(DYNiniExplorerWidth - 58) height:38

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 39) height:38 pos:[2013,193]
  label LBDYNimported align:#left pos:[2027,211] width:(DYNiniExplorerWidth - 57)

  groupbox GBDYN05 width:(DYNiniExplorerWidth - 39) height:74 pos:[2013,236]
  label LBDYNsource align:#left pos:[2022,254] width:(DYNiniExplorerWidth - 57)
  label LBDYNmodify01 align:#left pos:[2022,272] width:(DYNiniExplorerWidth - 57)
  label LBDYNmodify02 align:#left pos:[2027,290] width:(DYNiniExplorerWidth - 57)

  button BUDYNupdate width:(DYNiniExplorerWidth - 39)    pos:[2013,319]

  --- 2nd Tab
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 39) height:40 pos:[2013,57]
  label LBDYNpoints01 align:#left pos:[2022,76] width:(DYNiniExplorerWidth - 57)

  groupbox GBDYN02 width:(DYNiniExplorerWidth - 39) height:170 pos:[2013,101]
  checkbox CKDYNenable align:#left pos:[2022,119] width:(DYNiniExplorerWidth - 57)
  label LBDYNre01  align:#left pos:[2022,139] width:(DYNiniExplorerWidth - 57)
  dropdownlist DDDYNgeom align:#left pos:[2022,155] width:(DYNiniExplorerWidth - 57)
  label LBDYNvp01  align:#left pos:[2022,183] width:(DYNiniExplorerWidth - 57)
  dropdownlist DDDYNtype align:#left pos:[2022,199] width:(DYNiniExplorerWidth - 57)
  checkbox CKDYNnumbers align:#left pos:[2022,227] width:(DYNiniExplorerWidth - 87)
  colorPicker CPDYNcolor height:16 width:26 pos:[(DYNiniExplorerWidth - 62),227]
  checkbox CKDYNuseNode align:#left pos:[2022,247] width:(DYNiniExplorerWidth - 87)

  --- 3rd Tab
  checkbutton CBDYNresKt1 height:18 width:((DYNiniExplorerWidth - 40) / 3) pos:[2013,57]
  checkbutton CBDYNresKt2 height:18 width:((DYNiniExplorerWidth - 40) / 3) pos:[2013,57]
  checkbutton CBDYNresKt3 height:18 width:((DYNiniExplorerWidth - 40) / 3) pos:[2013,57]
  dotNetControl dnTabCtrl "System.Windows.Forms.TabControl" height:23 width:(DYNiniExplorerWidth - 29) pos:[14,77]
  dotNetControl DNDYNiniFileTree "System.Windows.Forms.TreeView" height:150 width:(DYNiniExplorerWidth - 41) align:#center pos:[14,102]
  button BUDYNuseNode width:(DYNiniExplorerWidth - 39) pos:[2013,256]

  groupbox GBDYN06 width:(DYNiniExplorerWidth - 39) height:40 pos:[2013,281]
  label LBDYNcurObj width:(DYNiniExplorerWidth - 57) pos:[2022,299]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNpSystemParams open do
  (
    DYNpSystemParams.title = DYNuiRolloutNames[10]

    local LOCtabNames      = #(DYNuiResourcesLabels[117], DYNuiResourcesLabels[118], DYNuiResourcesLabels[119])

    GBDYN01.text           = DYNuiResourcesGroups[35]
    GBDYN02.text           = DYNuiResourcesGroups[36]
    GBDYN03.text           = DYNuiResourcesGroups[33]
    GBDYN04.text           = DYNuiResourcesGroups[34]
    GBDYN05.text           = DYNuiResourcesGroups[7]
    GBDYN06.text           = DYNuiResourcesGroups[37]

    LBDYNre01.text         = DYNuiResourcesLabels[113]
    LBDYNvp01.text         = DYNuiResourcesLabels[111]

    CBDYNresKt1.text       = DYNuiResourcesLabels[114]
    CBDYNresKt2.text       = DYNuiResourcesLabels[115]
    CBDYNresKt3.text       = DYNuiResourcesLabels[116]

    LBDYNmodel01.text      = DYNuiResourcesLabels[51]
    LBDYNstring01.text     = DYNuiResourcesLabels[50]
    LBDYNmodify01.text     = DYNuiResourcesLabels[33]
    CKDYNenable.text       = DYNuiResourcesLabels[108]
    CKDYNnumbers.text      = DYNuiResourcesLabels[109]
    CKDYNuseNode.text      = DYNuiResourcesLabels[110]

    BUDYNupdate.text       = DYNuiResourcesButtons[14]
    BUDYNuseNode.text      = DYNuiResourcesButtons[2]
    DDDYNgeom.items        = LOCgeomArray
    DDDYNtype.items        = LOCtypeArray

    DYNFUNsetResourceKit LOCresourceKitMode

    DYNFUNdnTreeViewStyle DNDYNiniFileTree
    DNDYNiniFileTree.imageList = DYNdnSmImageList

    --- Set Up TAB 1 Control
    dnRolloutTabCtrl.padding.x = 10
    for i = 1 to LOCtabNames.count do (dnRolloutTabCtrl.tabpages.add LOCtabNames[i])
    dntabCtrl.ImageList    = DYNdnSmImageList
    dntabCtrl.padding.x    = 2
    dnTabCtrl.ShowToolTips = true

    --- Set Up TAB 2 Control
    for i = 1 to 6 do
    (
      dntabCtrl.tabpages.add ""
      dntabCtrl.tabpages.item[i-1].imageIndex  = i
      dntabCtrl.tabpages.item[i-1].toolTipText = DYNuiResourcesObjClasses[i]
    )
    dnTabCtrl.tabPages.removeAt 4

    dntabCtrl.multiLine = false
    dnTabCtrl.padding.x = 0
    dntabCtrl.SizeMode  = (dotNetClass "System.Windows.Forms.TabSizeMode").normal

    DYNFUNchangePStab 1
  )

  on DYNpSystemParams close do
  (
    LOCobj = undefined
  )

  on dnRolloutTabCtrl mouseUp arg do
  (
    DYNFUNchangePStab (dnRolloutTabCtrl.selectedTab.TabIndex + 1)
  )

  on dnTabCtrl mouseUp arg do
  (
    LOCobjectSwitch = dnTabCtrl.selectedTab.imageIndex
    DYNFUNdisplayINIobjFileArrays LOCobjectSwitch DYNpSystemParams LOCresourceKitMode
  )

  on DNDYNiniFileTree mousedown arg do
  (
    local LOCnode = DNDYNiniFileTree.getNodeAt arg.x arg.y
    if LOCnode != undefined then
    (
      if (subString LOCnode.name 1 1) == "!" then
      (
        local LOCdataArray = filterString LOCnode.tag "|"
        local LOCiniFile   = LOCdataArray[4]
        local LOCsizeArray = DYNFUNobjectINIparams (getfilenamefile LOCiniFile) LOCobjectSwitch LOCresourceKitMode
      )
    )
  )

  on CKDYNenable changed arg do
  (
    LOCobj.Enable_Particles = arg
  )

  on CKDYNnumbers changed arg do
  (
    particleFlow.beginEdit()
    if LOCopDisplay != undefined then LOCopDisplay.Show_Numbering = arg
    particleFlow.endEdit()
  )

  on CPDYNcolor changed arg do
  (
    particleFlow.beginEdit()
    if LOCopDisplay != undefined then LOCopDisplay.Color = arg
    particleFlow.endEdit()
    LOCobj.wirecolor = arg
  )

  on DDDYNtype selected arg do
  (
    particleFlow.beginEdit()
    if LOCopDisplay != undefined then
    (
      LOCopDisplay.type = arg - 1
      LOCopDisplay.Selected_Type = arg - 1
    )
    particleFlow.endEdit()
  )

  on DDDYNgeom selected arg do
  (
    particleFlow.beginEdit()
    if LOCopRender != undefined then LOCopRender.type = arg - 1
    particleFlow.endEdit()
  )

  on BUDYNuseNode pressed do
  (
    if LOCopInstance != undefined then
    (
      with undo label:DYNuiResourcesUndoLabels[10] on
      (
        particleFlow.beginEdit()

        if DNDYNiniFileTree.selectedNode != undefined then
        (
          if (subString DNDYNiniFileTree.selectedNode.name 1 1) == "!" then
          (
            DYNFUNloadVSPnodeCallBacks false -- Disable Auto-Update of Explorer for each element created
            (
              with redraw off
              (
                --- Extract Object INI File Data from TreeView ---------------------------------
                local LOCdataArray = filterString DNDYNiniFileTree.selectedNode.tag "|"
                local LOCiniFile   = LOCdataArray[4]
                local LOCsizeArray = DYNFUNobjectINIparams (getfilenamefile LOCiniFile) LOCobjectSwitch LOCresourceKitMode

                --- Delete Current Master Object if it Exists
                if isValidNode LOCmasterObject then delete LOCmasterObject
                LOCmasterObject = undefined

                --- Create Master Object - Vehicles or Furniture -------------------------------
                if LOCobjectSwitch == 1 or LOCobjectSwitch == 2 then
                (
                  if LOCsizeArray[5] != "" then
                  (
                    if (stricmp (substring LOCsizeArray[5] (LOCsizeArray[5].count - 3) -1) ".max") == 0 then -- IF A MAX FILE SELECTED
                    (
                      mergeMAXfile LOCsizeArray[5] #noRedraw #select #mergedups #useSceneMtlDups quiet:true
                      LOCmasterObject = selection[1]
                      if isValidNode LOCmasterObject then
                      (
                        if LOCmasterObject.modifiers.count > 0 then collapseStack LOCmasterObject -- Remove modifiers from imported objects derived from MAX files
                      )
                    )

                    if (stricmp (substring LOCsizeArray[5] (LOCsizeArray[5].count - 3) -1) ".rpc") == 0 then -- IF RPC CONTENT SELECTED
                    (
                      LOCmasterObject = try (RPC()) catch () -- undefined if RPC plugin is not loaded
                      if isValidNode LOCmasterObject then
                      (
                        if classof LOCmasterObject.specifyRPC == InterfaceFunction then -- specify RPC content if plugin supports it
                        (
                          LOCmasterObject.SpecifyRpc(LOCsizeArray[5])
                          LOCmasterObject.objectOffsetRot.z = 180 -- Fixes problem whereby marking appeared facing wrong way on road.
                        )
                      )
                      else -- if RPC plugin not loaded, simply create a dummy object
                      (
                        LOCmasterObject = dummy boxsize:[5.0,2.5,2.0]
                      )
                    )

                    if (substring LOCsizeArray[5] (LOCsizeArray[5].count - 1) -1) == "()"   then (LOCmasterObject = try (execute LOCsizeArray[5]) catch ()) -- IF A PLUGIN OF SOME TYPE
                  )

                  --- For Vehicles Only
                  if LOCobjectSwitch == 1 then
                  (
                    if superClassOf LOCmasterObject == geometryClass then
                    (
                      if LOCmasterObject.material == undefined then
                      (
                        LOCmasterObject.material = if sceneMaterials[DYNmatNameVehicles] == undefined then (DYNFUNmakeCivilViewVehicles (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps + "\\")) else sceneMaterials[DYNmatNameVehicles]
                      )
                      else
                      (
                        if DYNINIretainOpsMat then
                        (
                          LOCmasterObject.material = if sceneMaterials[DYNmatNameVehicles] == undefined then (DYNFUNmakeCivilViewVehicles (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps + "\\")) else sceneMaterials[DYNmatNameVehicles]
                        )
                      )
                    )

                    LOCmasterObject.wirecolor       = (color 100 150 225)

                    DYNFUNgenObjAppData LOCmasterObject LOCobjectSwitch 9 LOCiniFile (DYNFUNgetLocalTime()) "0" "0" DYNINIshadowSaver     -- Apply AppData to new object
                  )

                  --- For Furniture Only
                  if LOCobjectSwitch == 2 then
                  (
                    if superClassOf LOCmasterObject == geometryClass then
                    (
                      if LOCmasterObject.material == undefined then
                      (
                        LOCmasterObject.material = if sceneMaterials[DYNmatNameObjects] == undefined then (DYNFUNmakeCivilViewObjects  (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))    else sceneMaterials[DYNmatNameObjects]
                      )
                      else
                      (
                        if DYNINIretainOpsMat then
                        (
                          LOCmasterObject.material = if sceneMaterials[DYNmatNameObjects] == undefined then (DYNFUNmakeCivilViewObjects  (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))    else sceneMaterials[DYNmatNameObjects]
                        )
                      )
                    )

                    LOCmasterObject.wirecolor       = (color 225 225 150)

                    if (superclassof LOCobject) == GeometryClass and (substring LOCsizeArray[5] (LOCsizeArray[5].count - 1) -1) == "()" then -- Only for scripted plugin items
                    (
                      if LOCsizeArray[2] != 0.0 then (try (LOCmasterObject.length = LOCsizeArray[2]) catch ()) -- zero is considered to be a null value and should not be set
                      if LOCsizeArray[3] != 0.0 then (try (LOCmasterObject.width  = LOCsizeArray[3]) catch ())
                      if LOCsizeArray[4] != 0.0 then (try (LOCmasterObject.height = LOCsizeArray[4]) catch ())
                    )

                    local LOCfirstFaceID      = "0"
                    if classof LOCmasterObject == Editable_Mesh then
                    (
                      LOCfirstFaceID = (getfacematid LOCmasterObject 1) as string
                    )
                    if (try (LOCmasterObject.baseObject.matID) catch ()) != undefined then LOCfirstFaceID = LOCmasterObject.baseObject.matID as string
                    DYNFUNgenObjAppData LOCmasterObject LOCobjectSwitch LOCfirstFaceID LOCiniFile (DYNFUNgetLocalTime()) "" "" ""        -- Apply AppData to new object
                  )
                )

                --- Create Master Object - Trees -----------------------------------------------
                if LOCobjectSwitch == 3 then
                (
                  LOCmasterObject = if LOCsizeArray[1] == 2 then Foliage()  else Vsp_tree()
                  local LOCvariation = DYNINItreeVariation / 100.0
                  if classof LOCmasterObject == Foliage then -- For Foliage Objects Only
                  (
                    LOCmasterObject.genUV         = true
                    LOCmasterObject.seed          = random    1  16777215
                    LOCmasterObject.density       = random 0.80  1.0
                    LOCmasterObject.pruning       = random  0.0  0.2
                    LOCmasterObject.showLeaves    = true
                    LOCmasterObject.showTrunk     = true
                    LOCmasterObject.showFruit     = true
                    LOCmasterObject.showBranches  = true
                    LOCmasterObject.showFlowers   = true
                    LOCmasterObject.showRoots     = true
                    LOCmasterObject.CanopyMode    = 0
                    LOCmasterObject.LevelOfDetail = 2
                  )
                  else -- For DVSP Based Trees
                  (
                    if superClassOf LOCmasterObject == geometryClass then LOCmasterObject.material = if sceneMaterials[DYNmatNameTrees] == undefined then (DYNFUNmakeCivilViewTrees (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameTreeMaps + "\\")) else sceneMaterials[DYNmatNameTrees]
                    local LOCmapAlreadyUsed   = findItem (DYNFUNgetMatDiffuseMaps LOCmasterObject.material) (DYNFUNlowerCase (filenameFromPath LOCsizeArray[7]))     -- Check if this map is already in existing diffuse map array
                    LOCmasterObject.matID           = if LOCmapAlreadyUsed == 0 then (DYNFUNaddTreeMatChannel LOCmasterObject.material LOCsizeArray false) else (LOCmasterObject.matID = LOCmapAlreadyUsed)
                    LOCmasterObject.Nfaces          = 2
                    LOCmasterObject.backFaceCull    = false
                    LOCmasterObject.width           = LOCsizeArray[3]
                  )
                  LOCmasterObject.height          = LOCsizeArray[4]
                  LOCmasterObject.wirecolor       = (color 75 175 0)
                  DYNFUNgenObjAppData LOCmasterObject LOCobjectSwitch (if classof LOCmasterObject == Foliage then 1 else LOCmasterObject.matID) LOCiniFile (DYNFUNgetLocalTime()) "" "" ""       -- Apply AppData to new object

                )

                --- Create Master Object - Signs -----------------------------------------------
                if LOCobjectSwitch == 4 then
                (
                  local LOCtempObject
                  if LOCsizeArray[1] == 1 then LOCtempObject = Vsp_sign()
                  if LOCsizeArray[1] == 2 then LOCtempObject = Vsp_symb()
                  if LOCsizeArray[1] == 3 then LOCtempObject = Vsp_signal()
                  LOCmasterObject = if LOCtempObject == undefined then Vsp_sign() else LOCtempObject

                  if superClassOf LOCmasterObject == geometryClass then LOCmasterObject.material = if sceneMaterials[DYNmatNameObjects] == undefined then (DYNFUNmakeCivilViewObjects  (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))    else sceneMaterials[DYNmatNameObjects]
                  local LOCmapAlreadyUsed   = findItem (DYNFUNgetMatDiffuseMaps LOCmasterObject.material) (DYNFUNlowerCase (filenameFromPath LOCsizeArray[7]))     -- Check if this map is already in existing diffuse map array
                  if LOCsizeArray[1] != 2 then -- for standard Road Signs/Signals
                  (
                    LOCmasterObject.type          = if LOCmapAlreadyUsed == 0 then (DYNFUNaddSignMatChannel LOCmasterObject.material LOCsizeArray false) else (LOCmapAlreadyUsed)
                  )
                  else                         -- for Road Marking Symbols
                  (
                    LOCmasterObject.type          = if LOCmapAlreadyUsed == 0 then (DYNFUNaddSignMatChannel LOCmasterObject.material LOCsizeArray true) else (LOCmapAlreadyUsed)
                  )
                  LOCmasterObject.wirecolor       = (color 225 225 150)
                  LOCmasterObject.backFaceCull    = false
                  LOCmasterObject.width           = LOCsizeArray[3]
                  LOCmasterObject.height          = LOCsizeArray[4]
                  if LOCsizeArray[1] != 2 then -- for standard Road Signs/Signals
                  (
                    LOCmasterObject.pheight = LOCsizeArray[4] + LOCsizeArray[6] -- Height of Posts is Sign Height + Ground Clearance Value from Signs INI file
                    LOCmasterObject.posts   = LOCsizeArray[5]
                    LOCmasterObject.edgeOff = 0.3
                  )
                  else                         -- for Road Marking Symbols
                  (
                    LOCmasterObject.objectOffsetRot.z = 180 -- Fixes problem whereby marking appeared facing wrong way on road.
                  )
                  DYNFUNgenObjAppData LOCmasterObject LOCobjectSwitch LOCmasterObject.type LOCiniFile (DYNFUNgetLocalTime()) "" "" ""    -- Apply AppData to new object
                )

                --- Create Master Object - Primitives ------------------------------------------
                if LOCobjectSwitch == 6 then
                (
                  LOCmasterObject = try (execute (LOCsizeArray[8] + "()")) catch (box())
                  addmodifier LOCmasterObject (materialModifier materialID:(LOCsizeArray[5] as integer) name:DYNmatModName)

                  if superClassOf LOCmasterObject == geometryClass then LOCmasterObject.material = if sceneMaterials[DYNmatNameObjects] == undefined then (DYNFUNmakeCivilViewObjects  (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))    else sceneMaterials[DYNmatNameObjects]
                  try (LOCmasterObject.length     = LOCsizeArray[2]) catch ()
                  try (LOCmasterObject.depth      = LOCsizeArray[2]) catch ()
                  try (LOCmasterObject.width      = LOCsizeArray[3]) catch ()
                  try (LOCmasterObject.height     = LOCsizeArray[4]) catch ()
                  try (LOCmasterObject.radius     = LOCsizeArray[3] * 0.5) catch ()
                  try (LOCmasterObject.lengthSegs = 1) catch ()
                  try (LOCmasterObject.depthSegs  = 1) catch ()
                  try (LOCmasterObject.widthSegs  = 1) catch ()
                  try (LOCmasterObject.heightSegs = 1) catch ()
                  try (LOCmasterObject.Sides      = 12) catch ()
                  try (LOCmasterObject.mapCoords  = true) catch ()
                  LOCmasterObject.wirecolor       = (color 150 0 50)
                  DYNFUNgenObjAppData LOCmasterObject LOCobjectSwitch (try (LOCmasterObject.modifiers[DYNmatModName].materialID) catch ("0")) LOCiniFile (DYNFUNgetLocalTime()) "" "" ""    -- Apply AppData to new object
                )

                --- Move New Object To Pivot Point of Particle System or delete it if the object is not true geometry -----------------------------
                if isValidNode LOCmasterObject then
                (
                  if superclassof LOCmasterObject == geometryClass then
                  (
                    LOCmasterObject.pos = LOCobj.pos
                    if LOCopInstance != undefined then
                    (
                      LOCopInstance.Shape_Object     = LOCmasterObject
                      LOCopInstance.Acquire_Material = false
                      LOCopInstance.Acquire_Material = true

                      local LOCindex = 0
                      if (LOCtargetEvent.hasAction LOCopInstance &LOCindex) then
                      (
                        LOCtargetEvent.activateAction LOCindex 1
                      )
                    )
                  )
                  else
                  (
                    delete LOCmasterObject
                  )
                )

              )
              redrawViews()
            )
            DYNFUNloadVSPnodeCallBacks true                                       -- Enable auto update of Explorer
            DYNFUNnodeCreatedCallback() -- will check arrays for invalid node handles, then update Explorer Tree
            DYNproperties.DYNFUNscreenSelectionToList() -- required if no immediate selection is made. A selection would update Properties panel if open
          )
        )

        particleFlow.endEdit()

        --- Update pSystemParams Panel
        DYNFUNpSystemParams LOCobj
      )
    )
  )

  on CKDYNuseNode changed arg do
  (
    local LOCindex = 0
    particleFlow.beginEdit()
    if arg then
    (
      if LOCopInstance != undefined and (LOCtargetEvent.hasAction LOCopInstance &LOCindex) then
      (
        LOCtargetEvent.activateAction LOCindex 1
      )
      else
      (
        LOCopInstance = shape_instance()
        LOCtargetEvent.InsertAction LOCopInstance 2
      )
    )
    else
    (
      if LOCopInstance != undefined then
      (
        if LOCopInstance != undefined and (LOCtargetEvent.hasAction LOCopInstance &LOCindex) then
        (
          LOCtargetEvent.activateAction LOCindex 0
        )
      )
    )
    particleFlow.endEdit()
    DYNFUNpSystemParams LOCobj
  )

  on CBDYNresKt1 changed arg do (DYNFUNsetResourceKit 1; DYNFUNdisplayINIobjFileArrays LOCobjectSwitch DYNpSystemParams LOCresourceKitMode)
  on CBDYNresKt2 changed arg do (DYNFUNsetResourceKit 2; DYNFUNdisplayINIobjFileArrays LOCobjectSwitch DYNpSystemParams LOCresourceKitMode)
  on CBDYNresKt3 changed arg do (DYNFUNsetResourceKit 3; DYNFUNdisplayINIobjFileArrays LOCobjectSwitch DYNpSystemParams LOCresourceKitMode)

  on BUDYNupdate pressed do
  (
    APCFUNupdateImportedObjects #(LOCobj) true DYNtempPath
    APCFUNupdateAllPlacedObjectControllers()
  )

)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCJKbhVsJ/0MWVL3lFt3ifL9x9aVLdkEw7F
-- /8w2djzCpKbwvvIK7b9IKQul7+yETDGz8950A0sUhRLxKPTWJmxMPYeG4t/XYWer
-- 5AFU7TDayZiybaVyTjnPTqGMv5UxbCD2BpgdIe6ZZ3BWQdXq98JRZ/D3BY4KAd02
-- cqX+yeATfOboQqK7KuGmwZAghYdDKNW21L6DMc0Y7ecJuScq89lQPo3J01LuV+0e
-- wffd9PjNWWJDLEFfICvuWTF/PYX54R0t3xKrGspUsamJCXw5eSdy9ICz9LT42Oud
-- WTmaciiBwDPiUvxCoYA0mMbB8CKtNIrIfgeiQdvlaW6r7AUflbt1
-- -----END-SIGNATURE-----